# initialise data from life table
l = c(1, c(62, 34, 20, 16, 11, 7, 2, 2)*10^-6)
m = c(0, c(4600, 8700, 11600, 12700, 12700, 12700, 12700,
      12700))
k = length(l)

f_Euler <- function(lambda)
  {
  x = 0:(k-1)
  sum((lambda^-(x+1))*l*m) - 1
  }

lambda_est = uniroot(f_Euler,c(0.5,1.5))$root
print(lambda_est)

v0 = l/lambda_est^(0:(k-1))
v_theory = v0/v0[2]
print(v_theory)

R0 = sum(l*m)
print(R0) 
